﻿using System.Web.UI;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using System.Drawing;
using AjaxControlToolkit;

namespace Controls
{
    public class HoverCard : ScriptControl
    {
        private Panel _dragHandle = new Panel();

        protected override void OnInit(System.EventArgs e)
        {
            base.OnInit(e);
            _dragHandle.Width = Unit.Pixel(200);
            _dragHandle.Height = Unit.Pixel(30);
            _dragHandle.BackColor = Color.DarkSlateBlue;
        }

        protected override IEnumerable<ScriptDescriptor> GetScriptDescriptors()
        {
            yield return new ScriptControlDescriptor("HoverCard", this.ClientID);
        }

        protected override IEnumerable<ScriptReference> GetScriptReferences()
        {
            yield return new ScriptReference("Controls.JavaScript.HoverCard.js", "Controls");
        }

        protected override HtmlTextWriterTag TagKey
        {
            get
            {
                return HtmlTextWriterTag.Div;
            }
        }

        protected override void AddAttributesToRender(HtmlTextWriter writer)
        {
            base.AddAttributesToRender(writer);
            writer.AddStyleAttribute(HtmlTextWriterStyle.Width, "200px");
            writer.AddStyleAttribute(HtmlTextWriterStyle.Height, "150px");
            writer.AddStyleAttribute(HtmlTextWriterStyle.BackgroundColor, "Gainsboro");
        }

        protected override void OnPreRender(System.EventArgs e)
        {
            base.OnPreRender(e);
            this.Controls.Add(this._dragHandle);
            DragPanelExtender dpe = new DragPanelExtender();
            dpe.ID = this.ID + "DragPanelExtender";
            dpe.DragHandleID = this._dragHandle.ClientID;
            dpe.TargetControlID = this.ClientID;
            this.Controls.Add(dpe);

            ScriptManager sm = ScriptManager.GetCurrent(this.Page);
            string manualDisposeScript = string.Format(@"
                var elm = $get('{0}'); 
                if (elm !== null) {{ 
                    elm.control.dispose(); 
                    var behaviors = Sys.UI.Behavior.getBehaviors(elm); 
                    for (var i=0; i<behaviors.length; i++) {{ 
                        behaviors[i].dispose(); 
                    }} 
                    elm.parentNode.removeChild(elm);
                }}
            ", this.ClientID);
            sm.RegisterDispose(this, manualDisposeScript);
        }

        protected override void RenderContents(HtmlTextWriter writer)
        {
            base.RenderContents(writer);
            writer.Write("<span>Nazwisko: Jan Rutkowski</span><br /><span>Rodzinne miasto: Poznań</span><br /><span>Żona: Sylwia</span><br /><span>Rodzeństwo: Katarzyna</span>");
        }
    }
}
